/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna;

import com.sun.jna.Callback;
import com.sun.jna.CallbackThreadInitializer;
import com.sun.jna.FromNativeContext;
import com.sun.jna.FromNativeConverter;
import com.sun.jna.Function;
import com.sun.jna.FunctionResultContext$CallbackResultContext;
import com.sun.jna.IntegerType;
import com.sun.jna.Klass;
import com.sun.jna.Klass$JNIEnv;
import com.sun.jna.LastErrorException;
import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.NativeMapped;
import com.sun.jna.NativeMappedConverter;
import com.sun.jna.NativeString;
import com.sun.jna.Platform;
import com.sun.jna.Pointer;
import com.sun.jna.StructureReadContext;
import com.sun.jna.StructureWriteContext;
import com.sun.jna.StructureWriteContext$MethodResultContext;
import com.sun.jna.ToNativeContext;
import com.sun.jna.ToNativeConverter;
import com.sun.jna.TypeMapper;
import com.sun.jna.Union;
import com.sun.jna.Union$CallbackResultContext;
import com.sun.jna.Union$PointerType;
import com.sun.jna.WString;
import com.sun.jna.WeakMemoryHolder;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.nio.Buffer;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import melotr.MCDAClientWindowHelper;

public abstract class Structure {
    public static final int ALIGN_GNUC = 2;
    private String encoding;
    private Map<String, StructField> structFields;
    protected static final int CALCULATE_SIZE = -1;
    private static final Logger LOG = Logger.getLogger(Structure.class.getName());
    private static final ThreadLocal<Map<Pointer, Structure>> reads;
    public static final int ALIGN_DEFAULT = 0;
    private final Map<String, NativeStringTracking> nativeStrings = new HashMap<String, NativeStringTracking>(8);
    private int size = -1;
    private boolean readCalled;
    private TypeMapper typeMapper;
    private static final ThreadLocal<Set<Structure>> busy;
    static final Map<Class<?>, List<String>> fieldOrder;
    public static final int ALIGN_NONE = 1;
    public static final int ALIGN_MSVC = 3;
    static final Map<Class<?>, LayoutInfo> layoutInfo;
    private Pointer memory;
    private long typeInfo;
    private boolean autoWrite = true;
    private int alignType;
    private int actualAlignType;
    private int structAlignment;
    private boolean autoRead = true;
    private Structure[] array;
    private static final Pointer PLACEHOLDER_MEMORY;

    Object getFieldValue(Field field) {
        try {
            return field.get(this);
        }
        catch (Exception e) {
            throw new Error(MCDAClientWindowHelper.l(StructureWriteContext$MethodResultContext.u("\ucff9\u8da2\uaeb3\u1bcc\u6d56\u0a55\u014e\u3cdb\u7e8b\u33c8\u9fba\u3184\ua8bc\uf03d\u0908\ud09a\u403b\ud2ae\u4279\uc6b6\u30c6\u625b\u3a11\u0c86\uc31d")) + field.getName() + LastErrorException.l(StructureWriteContext$MethodResultContext.u("\ucfd2\u8d83\uaef0\u1bbe\u6d4f")) + this.getClass(), e);
        }
    }

    protected int getNativeSize(Class<?> nativeType) {
        return this.getNativeSize(nativeType, null);
    }

    TypeMapper getTypeMapper() {
        return this.typeMapper;
    }

    public void clear() {
        this.ensureAllocated();
        this.nativeStrings.clear();
        this.memory.clear(this.size());
    }

    protected void useMemory(Pointer m, int offset) {
        this.useMemory(m, offset, false);
    }

    private /* synthetic */ String format(Class<?> type) {
        String s = type.getName();
        int dot = s.lastIndexOf(MCDAClientWindowHelper.l(Klass$JNIEnv.n("\ue0a8")));
        return s.substring(dot + 1);
    }

    private /* synthetic */ void validateFields() {
        List<Field> fields = this.getFieldList();
        for (Field f : fields) {
            this.validateField(f.getName(), f.getType());
        }
    }

    public boolean equals(Object o) {
        return o instanceof Structure && o.getClass() == this.getClass() && ((Structure)o).getPointer().equals(this.getPointer());
    }

    private /* synthetic */ String toString(int indent, boolean showContents, boolean dumpMemory) {
        this.ensureAllocated();
        String LS = System.getProperty(LastErrorException.l(StructureWriteContext$MethodResultContext.u("\u7291\uf8a3\u6718\ubc27\udf50\u9e49\u0c4e\u72f7\u52ad\u77b1\u9288\uc19c\ue949\u079e")));
        String name = this.format(this.getClass()) + MCDAClientWindowHelper.l(StructureWriteContext$MethodResultContext.u("\u72e5")) + this.getPointer() + LastErrorException.l(StructureWriteContext$MethodResultContext.u("\u72ad"));
        if (!(this.getPointer() instanceof Memory)) {
            name = name + MCDAClientWindowHelper.l(StructureWriteContext$MethodResultContext.u("\u72a4\uf8ab")) + this.size() + LastErrorException.l(StructureWriteContext$MethodResultContext.u("\u72a4\uf8d1\u6776\ubc4f\udf62\u9e30\u0c7b"));
        }
        String prefix = "";
        for (int idx = 0; idx < indent; ++idx) {
            prefix = prefix + MCDAClientWindowHelper.l(StructureWriteContext$MethodResultContext.u("\u72a4\uf8a3"));
        }
        String contents = LS;
        if (!showContents) {
            contents = LastErrorException.l(StructureWriteContext$MethodResultContext.u("\u72d3\uf8e4\u6758\ubc3f"));
        } else {
            Iterator<StructField> i = this.fields().values().iterator();
            while (i.hasNext()) {
                StructField sf = i.next();
                Object value = this.getFieldValue(sf.field);
                String type = this.format(sf.type);
                String index = "";
                contents = contents + prefix;
                if (sf.type.isArray() && value != null) {
                    type = this.format(sf.type.getComponentType());
                    index = MCDAClientWindowHelper.l(StructureWriteContext$MethodResultContext.u("\u7296")) + Array.getLength(value) + LastErrorException.l(StructureWriteContext$MethodResultContext.u("\u72d9"));
                }
                contents = contents + String.format(MCDAClientWindowHelper.l(StructureWriteContext$MethodResultContext.u("\u72a4\uf8a3\u672a\ubc78\udf27\u9e56\u0c21\u72eb\u52c6\u77ca\u92a0\uc1d9\ue97a\u07fd")), type, sf.name, index, sf.offset);
                if (value instanceof Structure) {
                    value = ((Structure)value).toString(indent + 1, !(value instanceof ByReference), dumpMemory);
                }
                contents = contents + LastErrorException.l(StructureWriteContext$MethodResultContext.u("\u72b9"));
                contents = value instanceof Long ? contents + String.format(MCDAClientWindowHelper.l(StructureWriteContext$MethodResultContext.u("\u72b4\uf8fb\u672a\ubc3b\udf3f\u9e2b")), (Long)value) : (value instanceof Integer ? contents + String.format(LastErrorException.l(StructureWriteContext$MethodResultContext.u("\u72cd\uf8b2\u6753\ubc72\udf4a\u9e62")), (Integer)value) : (value instanceof Short ? contents + String.format(MCDAClientWindowHelper.l(StructureWriteContext$MethodResultContext.u("\u72b4\uf8fb\u672a\ubc3b\udf35\u9e2b")), (Short)value) : (value instanceof Byte ? contents + String.format(LastErrorException.l(StructureWriteContext$MethodResultContext.u("\u72cd\uf8b2\u6753\ubc72\udf4f\u9e62")), (Byte)value) : contents + String.valueOf(value).trim())));
                contents = contents + LS;
                if (i.hasNext()) continue;
                contents = contents + prefix + MCDAClientWindowHelper.l(StructureWriteContext$MethodResultContext.u("\u72b0"));
            }
        }
        if (indent == 0 && dumpMemory) {
            int BYTES_PER_ROW = 4;
            contents = contents + LS + LastErrorException.l(StructureWriteContext$MethodResultContext.u("\u72e9\uf8d6\u6762\ubc54\udf75\u9e3a\u0c72\u729a\u52c0\u77d7\u92e0")) + LS;
            byte[] buf = this.getPointer().getByteArray(0L, this.size());
            for (int i = 0; i < buf.length; ++i) {
                if (i % 4 == 0) {
                    contents = contents + MCDAClientWindowHelper.l(StructureWriteContext$MethodResultContext.u("\u7296"));
                }
                if (buf[i] >= 0 && buf[i] < 16) {
                    contents = contents + LastErrorException.l(StructureWriteContext$MethodResultContext.u("\u72b4"));
                }
                contents = contents + Integer.toHexString(buf[i] & 0xFF);
                if (i % 4 != 3 || i >= buf.length - 1) continue;
                contents = contents + MCDAClientWindowHelper.l(StructureWriteContext$MethodResultContext.u("\u7290")) + LS;
            }
            contents = contents + LastErrorException.l(StructureWriteContext$MethodResultContext.u("\u72d9"));
        }
        return name + MCDAClientWindowHelper.l(StructureWriteContext$MethodResultContext.u("\u72a4\uf8f8")) + contents;
    }

    private /* synthetic */ int addPadding(int calculatedSize, int alignment) {
        if (this.actualAlignType != 1 && calculatedSize % alignment != 0) {
            calculatedSize += alignment - calculatedSize % alignment;
        }
        return calculatedSize;
    }

    protected void writeField(StructField structField) {
        if (structField.isReadOnly) {
            return;
        }
        Object value = this.getFieldValue(structField.field);
        this.writeField(structField, value);
    }

    protected Structure(Pointer p, int alignType) {
        this(p, alignType, null);
    }

    Pointer getTypeInfo() {
        Pointer p = Structure.getTypeInfo(this).getPointer();
        this.cacheTypeInfo(p);
        return p;
    }

    public int size() {
        this.ensureAllocated();
        return this.size;
    }

    private /* synthetic */ void initializeFields() {
        List<Field> flist = this.getFieldList();
        for (Field f : flist) {
            try {
                Object o = f.get(this);
                if (o != null) continue;
                this.initializeField(f, f.getType());
            }
            catch (Exception e) {
                throw new Error(LastErrorException.l(Union$CallbackResultContext.U("\u667f\u1f39\u065d\uf984\u8898\u0a3d\ucbdd\u0577\u5231\ud070\ucdd6\uc24d\uedc5\u621c\u40ed\uc043\u7044\uef5d\u6014\ue8eb\ud053\ud8eb\ud32e\udab2\uc88a")) + f.getName() + MCDAClientWindowHelper.l(Union$CallbackResultContext.U("\u6654\u1f18\u061e\uf9f6\u8881")) + this.getClass(), e);
            }
        }
    }

    private /* synthetic */ void ensureAllocated(boolean avoidFFIType) {
        if (this.memory == null) {
            this.allocateMemory(avoidFFIType);
        } else if (this.size == -1) {
            this.size = this.calculateSize(true, avoidFFIType);
            if (!(this.memory instanceof AutoAllocated)) {
                try {
                    this.memory = this.memory.share(0L, this.size);
                }
                catch (IndexOutOfBoundsException e) {
                    throw new IllegalArgumentException(LastErrorException.l(FunctionResultContext$CallbackResultContext.p("\u51e4\u5354\uaf6c\ufdcc\ua22c\ub6f5\ubdd7\ub6c9\uc261\u56b1\u3d97\ud892\uf02b\u57e6\uf5d8\u8069\ue3b9\ub676\ua3b2\uc85e\u4104\u2f03\u53c2\ub286\ucf39\uf0a4\u12c8\u40a5\ufa63\u9bd7\u8be7\u8ef8\u1ec1\u98ba\u2d0a\uec32\u1fc7\ub276\u4779\ub0b9")), e);
                }
            }
        }
    }

    public Structure[] toArray(int size) {
        return this.toArray((Structure[])Array.newInstance(this.getClass(), size));
    }

    protected Structure() {
        this(0);
    }

    Map<String, StructField> fields() {
        return this.structFields;
    }

    protected Object readField(StructField structField) {
        Pointer p;
        Object currentValue;
        int offset = structField.offset;
        Class<?> fieldType = structField.type;
        FromNativeConverter readConverter = structField.readConverter;
        if (readConverter != null) {
            fieldType = readConverter.nativeType();
        }
        Object object = currentValue = Structure.class.isAssignableFrom(fieldType) || Callback.class.isAssignableFrom(fieldType) || Platform.HAS_BUFFERS && Buffer.class.isAssignableFrom(fieldType) || Pointer.class.isAssignableFrom(fieldType) || NativeMapped.class.isAssignableFrom(fieldType) || fieldType.isArray() ? this.getFieldValue(structField.field) : null;
        Object result = fieldType == String.class ? ((p = this.memory.getPointer(offset)) == null ? null : p.getString(0L, this.encoding)) : this.memory.getValue(offset, fieldType, currentValue);
        if (readConverter != null) {
            result = readConverter.fromNative(result, structField.context);
            if (currentValue != null && currentValue.equals(result)) {
                result = currentValue;
            }
        }
        if (fieldType.equals(String.class) || fieldType.equals(WString.class)) {
            if (result != null) {
                NativeStringTracking current = new NativeStringTracking(result);
                NativeStringTracking previous = this.nativeStrings.put(structField.name, current);
                if (previous != null) {
                    current.peer = previous.peer;
                }
            } else {
                this.nativeStrings.remove(structField.name);
            }
        }
        this.setFieldValue(structField.field, result, true);
        return result;
    }

    public void read() {
        if (this.memory == PLACEHOLDER_MEMORY) {
            return;
        }
        this.readCalled = true;
        this.ensureAllocated();
        if (!Structure.busy().add(this)) {
            return;
        }
        if (this instanceof ByReference) {
            Structure.reading().put(this.getPointer(), this);
        }
        try {
            for (StructField structField : this.fields().values()) {
                this.readField(structField);
            }
        }
        finally {
            Structure.busy().remove(this);
            if (this instanceof ByReference && Structure.reading().get(this.getPointer()) == this) {
                Structure.reading().remove(this.getPointer());
            }
        }
    }

    public static <T extends Structure> T newInstance(Class<T> type) throws IllegalArgumentException {
        Structure s = (Structure)Klass.newInstance(type);
        if (s instanceof ByValue) {
            s.allocateMemory();
        }
        return (T)s;
    }

    protected void allocateMemory(int size) {
        if (size == -1) {
            size = this.calculateSize(false);
        } else if (size <= 0) {
            throw new IllegalArgumentException(MCDAClientWindowHelper.l(Klass$JNIEnv.n("\u954d\u210b\u834d\u3227\ubb60\uf14b\u6c6d\u0fd4\uaf00\u72ce\ua586\u1d00\uc533\u82ec\u8d73\ud859\ueb12\u3e79\u7063\ud7cf\u9a82\u7df2\u77f2\ueb66\u4763\u36d4\ua14c\uae03\u9f18\u03f1\ucbef\u9fac\u8d23\u7c6a\u2c21\ud7c3\u59cf\u6fb7\u1dee\u21c8\u7b8c\ue094")) + size);
        }
        if (size != -1) {
            if (this.memory == null || this.memory instanceof AutoAllocated) {
                this.memory = this.autoAllocate(size);
            }
            this.size = size;
        }
    }

    public static <T extends Structure> T newInstance(Class<T> type, Pointer init) throws IllegalArgumentException {
        try {
            Constructor<T> ctor = Structure.getPointerConstructor(type);
            if (ctor != null) {
                return (T)((Structure)ctor.newInstance(init));
            }
        }
        catch (SecurityException ctor) {
        }
        catch (InstantiationException e) {
            String msg = LastErrorException.l(Union$CallbackResultContext.U("\uaee6\ucdf4\u13a5\u5d23\ube12\u64fe\u746f\uf637\ud905\u4d74\ua7b9\u3c9b\uea11\u0a2c\u8355\uebe1\ub7c9\ua459")) + type;
            throw new IllegalArgumentException(msg, e);
        }
        catch (IllegalAccessException e) {
            String msg = MCDAClientWindowHelper.l(Union$CallbackResultContext.U("\uaedc\ucdfb\u1388\u5d70\ube37\u64b0\u7442\uf630\ud927\u4d74\ua781\u3c9a\uea3b\u0a65\u836b\uebf3\ub7bc")) + type + LastErrorException.l(Union$CallbackResultContext.U("\uaefc\ucdc4\u13e2\u5d12\ube76\u64c9\u740b\uf645\ud97d\u4d50\ua781\u3ce2\uea73\u0a48\u836d\ueb8d\ub7b9\ua46c\udd74\ub7fe\u2109\uaf56\u9d27\u7b83\u09fc\uf4fe\udcff\uf4ba\u13da\u1239\u97cc\u3eda\u2804\u8c4e\u5cd9\ubdc4\ueb22"));
            throw new IllegalArgumentException(msg, e);
        }
        catch (InvocationTargetException e) {
            String msg = MCDAClientWindowHelper.l(Union$CallbackResultContext.U("\uae99\ucda4\u13d1\u5d28\ube6f\u64e3\u7416\uf67f\ud961\u4d69\ua7d5\u3cd4\uea6e\u0a63\u833a\uebb2\ub7f5\ua447\udd73\ub7d0\u2100\uaf67\u9d2b\u7bfa\u09fb\uf4ce\udcab\uf482\u13c0\u125d\u97d5\u3efe\u2812\u8c7b\u5cde\ubdf0\ueb3d\ufcf3\u73c2\uec4b\u682d\uc921\ua2a8\uf43f\uab6e\u2357\u48b9\u0110\udd6e\u468a\u597b\u5055")) + type;
            throw new IllegalArgumentException(msg, e);
        }
        T s = Structure.newInstance(type);
        if (init != PLACEHOLDER_MEMORY) {
            ((Structure)s).useMemory(init);
        }
        return s;
    }

    FFIType getFieldTypeInfo(StructField f) {
        ToNativeConverter nc;
        Class<?> type = f.type;
        Object value = this.getFieldValue(f.field);
        if (this.typeMapper != null && (nc = this.typeMapper.getToNativeConverter(type)) != null) {
            type = nc.nativeType();
            value = nc.toNative(value, new ToNativeContext());
        }
        return FFIType.get(value, type);
    }

    protected void allocateMemory() {
        this.allocateMemory(false);
    }

    private static /* synthetic */ void structureArrayCheck(Structure[] ss) {
        if (ByReference[].class.isAssignableFrom(ss.getClass())) {
            return;
        }
        Pointer base = ss[0].getPointer();
        int size = ss[0].size();
        for (int si = 1; si < ss.length; ++si) {
            if (ss[si].getPointer().peer == base.peer + (long)(size * si)) continue;
            String msg = LastErrorException.l(StructureWriteContext$MethodResultContext.u("\u1066\ufd06\ue5ad\u28a6\u1a01\u4583\ued88\u61c5\u33ba\u6153\u7a5d\u8074\u5fb5\u541f\uc2b5\u5780\u7e33\u1eaf\u7c5d\u680f\u61db\u2b41\u624f\u57f7\u3745\u6744\u9226\u5603\u5513\u79a3\u5c34\u0d25\u1de0\ub564\uc25d\ubd14\uda2e\u3c98\u1814\ud879\u1408\ucaca\u911b\u06cb\ub67b\u18f8\u236b\u1213\uee04\uae20\u4bc3\ue82c\uf74a\uf51e\uc3bb\ub60c\u9ab8\u4e2a\u19d0\u84a3\u21ea\u84cf\u5f55\u3c3c\u9469\u0e9b\uca11\u311c\u5588\uc0cd\u69b3\u0bd0\ub476\u2c78\udee0\ufc9b\u53a8\u7a5e\ub873\uab89\ua72d\ub30b\u969a\uef5e\ucdbe\u07b1\u7ac0\u9151\ub4ed\ue79b\u9677\ua4f6\u3968\u7cff\u9652\u1158\u1a4e\ucc1d")) + si + MCDAClientWindowHelper.l(StructureWriteContext$MethodResultContext.u("\u102c"));
            throw new IllegalArgumentException(msg);
        }
    }

    protected Memory autoAllocate(int size) {
        return new AutoAllocated(size);
    }

    private /* synthetic */ int addPadding(int calculatedSize) {
        return this.addPadding(calculatedSize, this.structAlignment);
    }

    public boolean dataEquals(Structure s, boolean clear) {
        byte[] ref;
        byte[] data;
        if (clear) {
            s.getPointer().clear(s.size());
            s.write();
            this.getPointer().clear(this.size());
            this.write();
        }
        if ((data = s.getPointer().getByteArray(0L, s.size())).length == (ref = this.getPointer().getByteArray(0L, this.size())).length) {
            for (int i = 0; i < data.length; ++i) {
                if (data[i] == ref[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private /* synthetic */ void validateField(String name, Class<?> type) {
        ToNativeConverter toNative;
        if (this.typeMapper != null && (toNative = this.typeMapper.getToNativeConverter(type)) != null) {
            this.validateField(name, toNative.nativeType());
            return;
        }
        if (type.isArray()) {
            this.validateField(name, type.getComponentType());
        } else {
            try {
                this.getNativeSize(type);
            }
            catch (IllegalArgumentException e) {
                String msg = LastErrorException.l(Klass$JNIEnv.n("\u4057\ufcaa\u3c1b\u4a49\u729a\u752a\u2050\u5ecc\ue38a\ubd03\ud877\ub5e2\u1f3a\u06fe\u42fe\u7831\u78a5\u0bc5\uedca\u09fe\ubd72\u4ff1\u312c\u318b\u8f16\u36d2\uea21")) + this.getClass() + MCDAClientWindowHelper.l(Klass$JNIEnv.n("\u4032\ufcd4\u3c0b\u4a71\u7293\u751f\u2050\u5efc\ue3b7\ubd26\ud868\ub5c2\u1f79\u069d")) + name + LastErrorException.l(Klass$JNIEnv.n("\u4039\ufce4\u3c45")) + type + MCDAClientWindowHelper.l(Klass$JNIEnv.n("\u407e\ufc87\u3c04")) + e.getMessage();
                throw new IllegalArgumentException(msg, e);
            }
        }
    }

    static Set<Structure> busy() {
        return busy.get();
    }

    public Object readField(String name) {
        this.ensureAllocated();
        StructField f = this.fields().get(name);
        if (f == null) {
            throw new IllegalArgumentException(LastErrorException.l(Union$CallbackResultContext.U("\u49f8\ud8d3\uf2a2\u1f63\u6279\u1d64\u31e8\u6346\ud836\uc499\u8905\uedec\ub650\ub055\u30ac")) + name);
        }
        return this.readField(f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int calculateSize(boolean force, boolean avoidFFIType) {
        LayoutInfo info;
        int size = -1;
        Class<?> clazz = this.getClass();
        Map<Class<?>, LayoutInfo> map = layoutInfo;
        synchronized (map) {
            info = layoutInfo.get(clazz);
        }
        if (info == null || this.alignType != info.alignType || this.typeMapper != info.typeMapper) {
            info = this.deriveLayout(force, avoidFFIType);
        }
        if (info != null) {
            this.structAlignment = info.alignment;
            this.structFields = info.fields;
            if (!info.variable) {
                map = layoutInfo;
                synchronized (map) {
                    if (!layoutInfo.containsKey(clazz) || this.alignType != 0 || this.typeMapper != null) {
                        layoutInfo.put(clazz, info);
                    }
                }
            }
            size = info.size;
        }
        return size;
    }

    protected int calculateSize(boolean force) {
        return this.calculateSize(force, false);
    }

    private /* synthetic */ void setFieldValue(Field field, Object value, boolean overrideFinal) {
        try {
            field.set(this, value);
        }
        catch (IllegalAccessException e) {
            int modifiers = field.getModifiers();
            if (Modifier.isFinal(modifiers)) {
                if (overrideFinal) {
                    throw new UnsupportedOperationException(MCDAClientWindowHelper.l(Union$PointerType.H("\u494f\u70dd>\u2f08\u750e\ua002\u6d1d\u6a7b\u44d4\u19ec\u9352\ub9ac\u3295\uf569\uf8d6\u4f7b\u75e3\u8719\uac9d\udaf5\u252b]\u34fd\u3fe7\u2077\uf69f\uef22\u8992\u24ca\u4372\ucd80\u4604\u0c4e\u8461\ue7c7\u6c73\uca2a\uc011\u983b\u25c9\u93d6\u3fc1\u59d3\ua98f\u44d0\u1c78\u8e07\ud897\ua864\u9c0d\u5112\u27b7\u47d2\ud6ee\u0238\u3a08\u9d73\u2001\uc544\u0f58\ub413\uf95a")) + field.getName() + LastErrorException.l(Union$PointerType.H("\u493c\u70a5 \u2f22\u755a\ua00c\u6d39\u6a05\u4490")) + this.getClass() + MCDAClientWindowHelper.l(Union$PointerType.H("\u497b")), e);
                }
                throw new UnsupportedOperationException(LastErrorException.l(Union$PointerType.H("\u495a\u70f1#\u2f2e\u7543\ua014\u6d24\u6a4b\u44c4\u19dc\u9317\ub998\u32c7\uf55e\uf8cd\u4f5a\u75e3\u872e\uac87\uda95\u2529g\u34ee\u3fc7\u207a\uf693\uef38\u89bc\u24c6\u4301\ucd92\u4628\u0c59\u8458\ue7d0\u6c43\uca7a")) + field.getName() + MCDAClientWindowHelper.l(Union$PointerType.H("\u4975\u70dci\u2f5b\u7513\ua075\u6d70\u6a7c\u44d9")) + this.getClass(), e);
            }
            throw new Error(LastErrorException.l(Union$PointerType.H("\u494e\u70eb2\u2f33\u755e\ua001\u6d33\u6a1f\u44d5\u19d7\u935b\ub996\u3295\uf542\uf8d7\u4f5e\u75a1\u8736\uac8d\uda95\u252fm\u34af\u3fd4\u2025\uf695\uef22\u89b5\u249f\u4355\ucd9b\u4661\u0c5a\u845d\ue7d1\u6c0f\uca39\uc068\u9868")) + field.getName() + MCDAClientWindowHelper.l(Union$PointerType.H("\u4975\u70dci\u2f5b\u7513\ua075\u6d70\u6a7c\u44d9")) + this.getClass(), e);
        }
    }

    private /* synthetic */ void initializeTypeMapper(TypeMapper mapper) {
        if (mapper == null) {
            mapper = Native.getTypeMapper(this.getClass());
        }
        this.typeMapper = mapper;
        this.layoutChanged();
    }

    public Pointer getPointer() {
        this.ensureAllocated();
        return this.memory;
    }

    public Structure[] toArray(Structure[] array) {
        this.ensureAllocated();
        if (this.memory instanceof AutoAllocated) {
            Memory m = (Memory)this.memory;
            int requiredSize = array.length * this.size();
            if (m.size() < (long)requiredSize) {
                this.useMemory(this.autoAllocate(requiredSize));
            }
        }
        array[0] = this;
        int size = this.size();
        for (int i = 1; i < array.length; ++i) {
            array[i] = Structure.newInstance(this.getClass(), this.memory.share(i * size, size));
            array[i].conditionalAutoRead();
        }
        if (!(this instanceof ByValue)) {
            this.array = array;
        }
        return array;
    }

    public int hashCode() {
        Pointer p = this.getPointer();
        if (p != null) {
            return this.getPointer().hashCode();
        }
        return this.getClass().hashCode();
    }

    static FFIType getTypeInfo(Object obj) {
        return FFIType.get(obj);
    }

    public static void autoRead(Structure[] ss) {
        Structure.structureArrayCheck(ss);
        if (ss[0].array == ss) {
            ss[0].autoRead();
        } else {
            for (int si = 0; si < ss.length; ++si) {
                if (ss[si] == null) continue;
                ss[si].autoRead();
            }
        }
    }

    private /* synthetic */ void allocateMemory(boolean avoidFFIType) {
        this.allocateMemory(this.calculateSize(true, avoidFFIType));
    }

    private /* synthetic */ Object initializeField(Field field, Class<?> type) {
        NativeMapped value = null;
        if (Structure.class.isAssignableFrom(type) && !ByReference.class.isAssignableFrom(type)) {
            try {
                value = (NativeMapped)Structure.newInstance(type, PLACEHOLDER_MEMORY);
                this.setFieldValue(field, value);
            }
            catch (IllegalArgumentException e) {
                String msg = LastErrorException.l(FunctionResultContext$CallbackResultContext.p("\u958a\u17e2\ue2ae\u7e31\u5096\ud5e1\u8cab\uf9d3\uc5e5\ue82a\u2d13\udd21\ue9bc\ue0a2\uc5c2\u8250\u2325\u04ba\ua1b2\u4d4d\u6d10\u3d87\ufd8d\u71d8\u851a\u612d\u612a\u59fc\u4f54\u4bea\uafa3\uf813\u3b8d\u37ea\u7f55\u1ac5\u201e\u818f\u6bc7\u751a"));
                throw new IllegalArgumentException(msg, e);
            }
        } else if (NativeMapped.class.isAssignableFrom(type)) {
            NativeMappedConverter tc = NativeMappedConverter.getInstance(type);
            value = tc.defaultValue();
            this.setFieldValue(field, value);
        }
        return value;
    }

    protected String getStringEncoding() {
        return this.encoding;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static <T extends Structure> int size(Class<T> type, T value) {
        int sz;
        LayoutInfo info;
        Map<Class<?>, LayoutInfo> map = layoutInfo;
        synchronized (map) {
            info = layoutInfo.get(type);
        }
        int n = sz = info != null && !info.variable ? info.size : -1;
        if (sz == -1) {
            if (value == null) {
                value = Structure.newInstance(type, PLACEHOLDER_MEMORY);
            }
            sz = value.size();
        }
        return sz;
    }

    public boolean getAutoRead() {
        return this.autoRead;
    }

    static <T extends Structure> T updateStructureByReference(Class<T> type, T s, Pointer address) {
        if (address == null) {
            s = null;
        } else if (s == null || !address.equals(((Structure)s).getPointer())) {
            Structure s1 = Structure.reading().get(address);
            if (s1 != null && type.equals(s1.getClass())) {
                s = s1;
                ((Structure)s).autoRead();
            } else {
                s = Structure.newInstance(type, address);
                ((Structure)s).conditionalAutoRead();
            }
        } else {
            ((Structure)s).autoRead();
        }
        return (T)s;
    }

    private static /* synthetic */ <T> Constructor<T> getPointerConstructor(Class<T> type) {
        for (Constructor<?> constructor : type.getConstructors()) {
            Class<?>[] parameterTypes = constructor.getParameterTypes();
            if (parameterTypes.length != 1 || !parameterTypes[0].equals(Pointer.class)) continue;
            return constructor;
        }
        return null;
    }

    private static /* synthetic */ <T extends Structure> T newInstance(Class<T> type, long init) {
        try {
            T s = Structure.newInstance(type, init == 0L ? PLACEHOLDER_MEMORY : new Pointer(init));
            if (init != 0L) {
                ((Structure)s).conditionalAutoRead();
            }
            return s;
        }
        catch (Throwable e) {
            LOG.log(Level.WARNING, MCDAClientWindowHelper.l(Union$CallbackResultContext.U("\uaedf\ucddb\u13ba\u5d3e\ube76\u649b\u7444\uf62b\ud929\u4d72\ua7c8\u3c96\uea27\u0a20\u8365\uebe1\ub7f5\ua417\udd35\ub7d0\u2156\uaf3f\u9d30\u7baf\u09bf\uf480\udce3\uf4d8\u1382")), e);
            return null;
        }
    }

    protected int fieldOffset(String name) {
        this.ensureAllocated();
        StructField f = this.fields().get(name);
        if (f == null) {
            throw new IllegalArgumentException(LastErrorException.l(Union$CallbackResultContext.U("\u44dc\ub8f6\ufbe2\u0f62\u3a57\u2698\u4170\u97ab\u99be\u69dd\ue0fe\u2e8f\ucd30\uec89\u1630")) + name);
        }
        return f.offset;
    }

    public boolean dataEquals(Structure s) {
        return this.dataEquals(s, false);
    }

    protected int getStructAlignment() {
        if (this.size == -1) {
            this.calculateSize(true);
        }
        return this.structAlignment;
    }

    public void autoWrite() {
        if (this.getAutoWrite()) {
            this.write();
            if (this.array != null) {
                for (int i = 1; i < this.array.length; ++i) {
                    this.array[i].autoWrite();
                }
            }
        }
    }

    static void validate(Class<? extends Structure> cls) {
        try {
            cls.getConstructor(new Class[0]);
            return;
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        throw new IllegalArgumentException(MCDAClientWindowHelper.l(Union$PointerType.H("\u61c6\ub2d3\u3d42\u2e45\u9508\u7551\u4293\ue912\ud1b2\uf446\u2d9b\u5d0d\uc875\ua1c0\u796e\uc330\ube10\ufb98\ua117\u9323\uacce\u5477\u5839\udc6c\u00cb\u6bf1\u6e47\ud364\uf928\u9f3a\u4a13\ub835\ucaa7\u0545\u9743\ucb06\udc55\u8b72\u122d\u91c4\u212d")) + cls.getName());
    }

    public void setAutoRead(boolean auto) {
        this.autoRead = auto;
    }

    protected Structure(Pointer p, int alignType, TypeMapper mapper) {
        this.setAlignType(alignType);
        this.setStringEncoding(Native.getStringEncoding(this.getClass()));
        this.initializeTypeMapper(mapper);
        this.validateFields();
        if (p != null) {
            this.useMemory(p, 0, true);
        } else {
            this.allocateMemory(-1);
        }
        this.initializeFields();
    }

    private /* synthetic */ void writeField(StructField structField, Object value) {
        int offset = structField.offset;
        Class<?> fieldType = structField.type;
        ToNativeConverter converter = structField.writeConverter;
        if (converter != null) {
            value = converter.toNative(value, new StructureWriteContext(this, structField.field));
            fieldType = converter.nativeType();
        }
        if (String.class == fieldType || WString.class == fieldType) {
            if (value != null) {
                NativeStringTracking current = new NativeStringTracking(value);
                NativeStringTracking previous = this.nativeStrings.put(structField.name, current);
                if (previous != null && value.equals(previous.value)) {
                    current.peer = previous.peer;
                    return;
                }
                boolean wide = fieldType == WString.class;
                NativeString nativeString = wide ? new NativeString(value.toString(), true) : new NativeString(value.toString(), this.encoding);
                current.peer = nativeString;
                value = nativeString.getPointer();
            } else {
                this.nativeStrings.remove(structField.name);
            }
        }
        try {
            this.memory.setValue(offset, value, fieldType);
        }
        catch (IllegalArgumentException e) {
            String msg = LastErrorException.l(Klass$JNIEnv.n("\ueeca\u00af\ubb79\ud976\uf99d\ucdb3\u0161\uc4e1\u5229\ud3ae\u24ab\u6b2d\u057f\u65aa\u30b7\u60d4\u7705")) + structField.name + MCDAClientWindowHelper.l(Klass$JNIEnv.n("\ueebb\u00cb\ubb7c\ud952\uf98d\ucdd7\u0170\uc4c6\u522f\ud3d2\u24ac\u6b06\u057f\u6592\u30f3\u60a5\u7754\u7982")) + structField.type + (structField.type == fieldType ? "" : LastErrorException.l(Klass$JNIEnv.n("\ueec0\u008a\ubb1c\ud91b\uf9f3\ucdd7\u011b\uc48f\u5215\ud383\u24cd\u6b4d\u0506\u659f")) + fieldType + MCDAClientWindowHelper.l(Klass$JNIEnv.n("\ueef9"))) + LastErrorException.l(Klass$JNIEnv.n("\ueeb5\u00fb\ubb7c\ud96b\uf997\ucda4\u017c\uc4b3\u5225\ud3fd\u24ed\u6b2a\u0575\u65b2\u30f3\u6087\u7752\u79e2\ue72c\ue80f\u5ba6\ud65e\u90e0\u4f20\u1be5\ue5f3\u82cc\u1e3d\u88a6\u058a\u52b6\u2f53\uf084\ud403\ue066\u4cf7\ubd8c\uad6d\ud245\u6c74\ub101\u92f2\u96e0"));
            throw new IllegalArgumentException(msg, e);
        }
    }

    public static List<String> createFieldsOrder(List<String> baseFields, String ... extraFields) {
        return Structure.createFieldsOrder(baseFields, Arrays.asList(extraFields));
    }

    protected int getNativeAlignment(Class<?> type, Object value, boolean isFirstElement) {
        int alignment = 1;
        if (NativeMapped.class.isAssignableFrom(type)) {
            NativeMappedConverter tc = NativeMappedConverter.getInstance(type);
            type = tc.nativeType();
            value = tc.toNative(value, new ToNativeContext());
        }
        int size = Native.getNativeSize(type, value);
        if (type.isPrimitive() || Long.class == type || Integer.class == type || Short.class == type || Character.class == type || Byte.class == type || Boolean.class == type || Float.class == type || Double.class == type) {
            alignment = size;
        } else if (Pointer.class.isAssignableFrom(type) && !Function.class.isAssignableFrom(type) || Platform.HAS_BUFFERS && Buffer.class.isAssignableFrom(type) || Callback.class.isAssignableFrom(type) || WString.class == type || String.class == type) {
            alignment = Native.POINTER_SIZE;
        } else if (Structure.class.isAssignableFrom(type)) {
            if (ByReference.class.isAssignableFrom(type)) {
                alignment = Native.POINTER_SIZE;
            } else {
                if (value == null) {
                    value = Structure.newInstance(type, PLACEHOLDER_MEMORY);
                }
                alignment = ((Structure)value).getStructAlignment();
            }
        } else if (type.isArray()) {
            alignment = this.getNativeAlignment(type.getComponentType(), null, isFirstElement);
        } else {
            throw new IllegalArgumentException(MCDAClientWindowHelper.l(StructureWriteContext$MethodResultContext.u("\u2c7b\ud3c7\u2862\u03dc\u42c6")) + type + LastErrorException.l(StructureWriteContext$MethodResultContext.u("\u2c46\ud3af\u283a\u03b3\u428f\u325e\ub71d\u93e9\u4b01\u4af4\ubcdc\u983d\ud3ca\ucb73\u462e\u09bf\u4754\uc0f5\uc3b1\u47c3\uec5a\u250e\u7928\u2f47\u27f9\u2d03\u2b92\u05ce\u9be3")));
        }
        if (this.actualAlignType == 1) {
            alignment = 1;
        } else if (this.actualAlignType == 3) {
            alignment = Math.min(8, alignment);
        } else if (this.actualAlignType == 2) {
            if (!(isFirstElement && Platform.isMac() && Platform.isPPC())) {
                alignment = Math.min(Native.MAX_ALIGNMENT, alignment);
            }
            if (!isFirstElement && Platform.isAIX() && (type == Double.TYPE || type == Double.class)) {
                alignment = 4;
            }
        }
        return alignment;
    }

    protected int getNativeSize(Class<?> nativeType, Object value) {
        return Native.getNativeSize(nativeType, value);
    }

    public String toString() {
        return this.toString(Boolean.getBoolean(MCDAClientWindowHelper.l(StructureWriteContext$MethodResultContext.u("\u72a7\uf8a4\u6727\ubc6c\udf2a\u9e4f\u0c76\u72f7\u52a3\u77ae\u92bc\uc185\ue979\u079e\u5322"))));
    }

    static Map<Pointer, Structure> reading() {
        return reads.get();
    }

    public static List<String> createFieldsOrder(String field) {
        return Collections.unmodifiableList(Collections.singletonList(field));
    }

    void setFieldValue(Field field, Object value) {
        this.setFieldValue(field, value, false);
    }

    protected Structure(Pointer p) {
        this(p, 0);
    }

    private /* synthetic */ void layoutChanged() {
        if (this.size != -1) {
            this.size = -1;
            if (this.memory instanceof AutoAllocated) {
                this.memory = null;
            }
            this.ensureAllocated();
        }
    }

    void conditionalAutoRead() {
        if (!this.readCalled) {
            this.autoRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private /* synthetic */ List<String> fieldOrder() {
        Class<?> clazz = this.getClass();
        Map<Class<?>, List<String>> map = fieldOrder;
        synchronized (map) {
            List<String> list = fieldOrder.get(clazz);
            if (list == null) {
                list = this.getFieldOrder();
                fieldOrder.put(clazz, list);
            }
            return list;
        }
    }

    protected List<Field> getFields(boolean force) {
        List<Field> flist = this.getFieldList();
        HashSet<String> names = new HashSet<String>();
        for (Field f : flist) {
            names.add(f.getName());
        }
        List<String> fieldOrder = this.fieldOrder();
        if (fieldOrder.size() != flist.size() && flist.size() > 1) {
            if (force) {
                throw new Error(LastErrorException.l(FunctionResultContext$CallbackResultContext.p("\u44bd\ud826\u4f95\u9ba6\u0679\ua396\ud0f5\ua2ba\uea03\u7f0c\u3c9e\u5dda\u7357\u48c7\ua0fd\u649e\u24ff\ue37f\uf8db\u55d6\u1ac0\ue8ee\u51d5\ue123\uaa86\u6e9d\u296b\u5538\u9b14")) + this.getClass() + (fieldOrder.size() < flist.size() ? MCDAClientWindowHelper.l(FunctionResultContext$CallbackResultContext.p("\u44ce\ud806\u4f88\u9b86\u0669\ua3f2\ud0ee\ua297\uea12\u7f32\u3c89\u5dfd\u734c\u48c7\ua0fd\u64af\u24f6\ue30b\uf8f1\u55fa\u1acb\ue8ce\u51c0\ue153")) : LastErrorException.l(FunctionResultContext$CallbackResultContext.p("\u44b7\ud85b\u4fec\u9bc5\u0615\ua3f2\ud09d\ua2d4\uea6c\u7f7b\u3cf4\u5da9\u7335\u48d8\ua080\u64e3\u2484\ue31b"))) + MCDAClientWindowHelper.l(FunctionResultContext$CallbackResultContext.p("\u44ce\ud80c\u4f86\u9b8e\u067f\ua3a1\ud0a0\ua2a3")) + fieldOrder.size() + LastErrorException.l(FunctionResultContext$CallbackResultContext.p("\u44b3\ud872\u4fcf")) + Structure.sort(fieldOrder) + MCDAClientWindowHelper.l(FunctionResultContext$CallbackResultContext.p("\u44c7\ud842\u4f93\u9b8c\u063a\ua3bf\ud0e1\ua28c\uea05\u7f7a\u3cd9\u5deb\u7346\u48d2\ua0f8\u64aa\u24e1\ue34e\uf8f0\u55b4\u1ac2\ue8d2\u51c2\ue157\uaacb\u6efe\u2924\u553d")) + flist.size() + LastErrorException.l(FunctionResultContext$CallbackResultContext.p("\u44b3\ud872\u4fcf")) + Structure.sort(names) + MCDAClientWindowHelper.l(FunctionResultContext$CallbackResultContext.p("\u448e")));
            }
            return null;
        }
        HashSet<String> orderedNames = new HashSet<String>(fieldOrder);
        if (!orderedNames.equals(names)) {
            throw new Error(LastErrorException.l(FunctionResultContext$CallbackResultContext.p("\u44bd\ud826\u4f95\u9ba6\u0679\ua396\ud0f5\ua2ba\uea03\u7f0c\u3c9e\u5dda\u7357\u48c7\ua0fd\u649e\u24ff\ue37f\uf8db\u55d6\u1ac0\ue8ee\u51d5\ue123\uaa86\u6e9d\u296b\u5538\u9b14")) + this.getClass() + MCDAClientWindowHelper.l(FunctionResultContext$CallbackResultContext.p("\u44ce\ud810\u4f82\u9b97\u066f\ua3a0\ud0ee\ua28b\uea46\u7f7c\u3c98\u5de2\u7346\u48c2\ua0b4\u64e3")) + Structure.sort(fieldOrder) + LastErrorException.l(FunctionResultContext$CallbackResultContext.p("\u44c7\ud872\u4f90\u9bbb\u0673\ua381\ud0e8\ua2e8\uea02\u7f4d\u3cd9\u5dd1\u734c\u48f5\ua0b4\u6496\u24f2\ue36f\uf8f7\u55cc\u1a84\ue8ef\u51c2\ue168\uaac3\u6edc\u2976\u5533\u9b50\u38dd\u58bb\uffe3\u5984\ucb20\u6d04\uc314\ub213\u7176\u9c9c\u0fa8\uad13\u18eb\u1ab4")) + Structure.sort(names) + MCDAClientWindowHelper.l(FunctionResultContext$CallbackResultContext.p("\u448e")));
        }
        this.sortFields(flist, fieldOrder);
        return flist;
    }

    protected void setAlignType(int alignType) {
        this.alignType = alignType;
        if (alignType == 0 && (alignType = Native.getStructureAlignment(this.getClass())) == 0) {
            alignType = Platform.isWindows() ? 3 : 2;
        }
        this.actualAlignType = alignType;
        this.layoutChanged();
    }

    protected void useMemory(Pointer m) {
        this.useMemory(m, 0);
    }

    protected void ensureAllocated() {
        this.ensureAllocated(false);
    }

    private /* synthetic */ Class<?> baseClass() {
        if ((this instanceof ByReference || this instanceof ByValue) && Structure.class.isAssignableFrom(this.getClass().getSuperclass())) {
            return this.getClass().getSuperclass();
        }
        return this.getClass();
    }

    public void writeField(String name, Object value) {
        this.ensureAllocated();
        StructField structField = this.fields().get(name);
        if (structField == null) {
            throw new IllegalArgumentException(LastErrorException.l(StructureWriteContext$MethodResultContext.u("\u921e\ua02a\ud670\udb79\u92d0\ud4d7\u2a4c\u51c8\u262e\uc789\u844b\u602a\u7547\uee2d\u3c50")) + name);
        }
        this.setFieldValue(structField.field, value);
        this.writeField(structField, value);
    }

    public static List<String> createFieldsOrder(List<String> baseFields, List<String> extraFields) {
        ArrayList<String> fields = new ArrayList<String>(baseFields.size() + extraFields.size());
        fields.addAll(baseFields);
        fields.addAll(extraFields);
        return Collections.unmodifiableList(fields);
    }

    public static void autoWrite(Structure[] ss) {
        Structure.structureArrayCheck(ss);
        if (ss[0].array == ss) {
            ss[0].autoWrite();
        } else {
            for (int si = 0; si < ss.length; ++si) {
                if (ss[si] == null) continue;
                ss[si].autoWrite();
            }
        }
    }

    public void setAutoSynch(boolean auto) {
        this.setAutoRead(auto);
        this.setAutoWrite(auto);
    }

    static {
        layoutInfo = new WeakHashMap();
        fieldOrder = new WeakHashMap();
        reads = new ThreadLocal<Map<Pointer, Structure>>(){

            @Override
            protected synchronized Map<Pointer, Structure> initialValue() {
                return new HashMap<Pointer, Structure>();
            }
        };
        busy = new ThreadLocal<Set<Structure>>(){

            @Override
            protected synchronized Set<Structure> initialValue() {
                return new StructureSet();
            }
        };
        PLACEHOLDER_MEMORY = new Pointer(0L){

            @Override
            public Pointer share(long offset, long sz) {
                return this;
            }
        };
    }

    public void writeField(String name) {
        this.ensureAllocated();
        StructField f = this.fields().get(name);
        if (f == null) {
            throw new IllegalArgumentException(MCDAClientWindowHelper.l(Klass$JNIEnv.n("\uee9e\u00cd\ubb62\ud909\uf9c2\ucddd\u0135\uc4ca\u5263\ud39e\u24e1\u6b51\u0537\u6585\u30ba")) + name);
        }
        this.writeField(f);
    }

    protected void sortFields(List<Field> fields, List<String> names) {
        block0: for (int i = 0; i < names.size(); ++i) {
            String name = names.get(i);
            for (int f = 0; f < fields.size(); ++f) {
                Field field = fields.get(f);
                if (!name.equals(field.getName())) continue;
                Collections.swap(fields, i, f);
                continue block0;
            }
        }
    }

    private static /* synthetic */ <T extends Comparable<T>> List<T> sort(Collection<? extends T> c) {
        ArrayList<? extends T> list = new ArrayList<T>(c);
        Collections.sort(list);
        return list;
    }

    protected void setStringEncoding(String encoding) {
        this.encoding = encoding;
    }

    protected Structure(int alignType) {
        this(null, alignType);
    }

    public void autoRead() {
        if (this.getAutoRead()) {
            this.read();
            if (this.array != null) {
                for (int i = 1; i < this.array.length; ++i) {
                    this.array[i].autoRead();
                }
            }
        }
    }

    public static List<String> createFieldsOrder(String ... fields) {
        return Collections.unmodifiableList(Arrays.asList(fields));
    }

    protected List<String> getFieldOrder() {
        LinkedList<String> fields = new LinkedList<String>();
        for (Class<?> clazz = this.getClass(); clazz != Structure.class; clazz = clazz.getSuperclass()) {
            FieldOrder order = clazz.getAnnotation(FieldOrder.class);
            if (order == null) continue;
            fields.addAll(0, Arrays.asList(order.value()));
        }
        return Collections.unmodifiableList(fields);
    }

    private /* synthetic */ LayoutInfo deriveLayout(boolean force, boolean avoidFFIType) {
        int calculatedSize = 0;
        List<Field> fields = this.getFields(force);
        if (fields == null) {
            return null;
        }
        LayoutInfo info = new LayoutInfo();
        info.alignType = this.alignType;
        info.typeMapper = this.typeMapper;
        boolean firstField = true;
        for (Field field : fields) {
            int modifiers = field.getModifiers();
            Class<?> type = field.getType();
            if (type.isArray()) {
                info.variable = true;
            }
            StructField structField = new StructField();
            structField.isVolatile = Modifier.isVolatile(modifiers);
            structField.isReadOnly = Modifier.isFinal(modifiers);
            if (structField.isReadOnly) {
                if (!Platform.RO_FIELDS) {
                    throw new IllegalArgumentException(LastErrorException.l(Union$CallbackResultContext.U("\ua7e1\ud214\u8ab1\u0414\u4857\u4394\ua1ed\ucafb\ucb7e\ucc41\u4dc8\u7490\uf2a1\u96ff\ue3c7\u30d7\u5a19\u43c5\u49f9\ud1a8\u1cbb\u52a7\u84c0\u61fe\u0d87\u2b8a\u97f2\ub868\u1367\u8348\uf528\u9a89\ud646\u8132\u6833\u1357\u4c68\u2af9\u9cff\u1ea3\udfb2\ue99b\ubeb6\u1d23\uba00\uc44f\u3a49\ub97e\uc063\u5950")) + field.getName() + MCDAClientWindowHelper.l(Union$CallbackResultContext.U("\ua7a2\ud25c\u8a9f\u040e\u4833\u43aa\ua1f9\ucab5\ucb0a")) + this.getClass() + LastErrorException.l(Union$CallbackResultContext.U("\ua7e5")));
                }
                field.setAccessible(true);
            }
            structField.field = field;
            structField.name = field.getName();
            structField.type = type;
            if (Callback.class.isAssignableFrom(type) && !type.isInterface()) {
                throw new IllegalArgumentException(MCDAClientWindowHelper.l(Union$CallbackResultContext.U("\ua79f\ud241\u8ad3\u045b\u486d\u43ff\ua1ac\ucae0\ucb06\ucc47\u4d97\u74cb\uf294\u96b4\ue3b3\u308b\u5a23\u4394\u49d5\ud1f7\u1cdb\u52e4\u84a7\u61a7\u0dfe\u2b96")) + field.getName() + LastErrorException.l(Union$CallbackResultContext.U("\ua792\ud25c\u8ab5\u0412\u4804\u43b6\ua180\ucab9\ucb7f\ucc0e\u4dcc\u748d\uf2a1\u96f8\ue3c6\u30d7\u5a5c\u43c4\u49ea\ud1b9\u1ca8\u52ad")));
            }
            if (type.isArray() && Structure.class.equals(type.getComponentType())) {
                String msg = MCDAClientWindowHelper.l(Union$CallbackResultContext.U("\ua782\ud250\u8ad2\u045a\u486b\u43ef\ua1f9\ucac1\ucb17\ucc15\u4da1\u74c9\uf28c\u96ad\ue3a3\u308f\u5a60\u439e\u4987\ud1e3\u1cd3\u52f8\u84b8\u61e3\u0db3\u2bc4\u979d\ub834\u135a\u8359\uf54d\u9acb\ud673\u8163\u684a\u131c\u4c1d\u2aa7\u9c83\u1ef8\udfdd\ue996\ubec7\u1d5f\uba64\uc411\u3a29\ub930\uc04e\u594b\ub6e3\u8730\ue238\u2c67\u7302\u886d\u42fe\u20bd\uc59e\u00f5\u984e\u080f\u1c59\u463e\ue370\u59de\ufe88\u6d85\uc7ca\uf57c\u72c3\u5728\u9d49\u6734\u4fb2\u12d5\udfa0\u372d\u24e1\ucb1c\u493a\u2fcc\u52e6\u06df\u7832\ua59a\ua335\ub5de\u44df\u9b23\u9c69\u0564\u50c9\u06c6\ua30d\uf8e0\u2c35\ucb5a\u70d9\u7c1e\ua773\ua27b\uf952\u4922\ud471\uef38\u6e0c\udcfa"));
                throw new IllegalArgumentException(msg);
            }
            int fieldAlignment = 1;
            if (Modifier.isPublic(field.getModifiers())) {
                Object value = this.getFieldValue(structField.field);
                if (value == null && type.isArray()) {
                    if (force) {
                        throw new IllegalStateException(LastErrorException.l(Union$CallbackResultContext.U("\ua7f4\ud20e\u8aaa\u0406\u480e\u43e2\ua1c6\ucab2\ucb7f\ucc42\u4dc9\u7490\uf2a1\u96fc\ue3dd\u30d0\u5a4d\u4396\u49ee\ud1bd\u1ceb\u52a1\u84dc\u61e3\u0dd3\u2b91\u97f6\ub865\u136a\u831f\uf522\u9a83")));
                    }
                    return null;
                }
                Class<Object> nativeType = type;
                if (NativeMapped.class.isAssignableFrom(type)) {
                    NativeMappedConverter tc = NativeMappedConverter.getInstance(type);
                    nativeType = tc.nativeType();
                    structField.writeConverter = tc;
                    structField.readConverter = tc;
                    structField.context = new StructureReadContext(this, field);
                } else if (this.typeMapper != null) {
                    ToNativeConverter writeConverter = this.typeMapper.getToNativeConverter(type);
                    FromNativeConverter readConverter = this.typeMapper.getFromNativeConverter(type);
                    if (writeConverter != null && readConverter != null) {
                        nativeType = (value = writeConverter.toNative(value, new StructureWriteContext(this, structField.field))) != null ? value.getClass() : Pointer.class;
                        structField.writeConverter = writeConverter;
                        structField.readConverter = readConverter;
                        structField.context = new StructureReadContext(this, field);
                    } else if (writeConverter != null || readConverter != null) {
                        String msg = MCDAClientWindowHelper.l(Union$CallbackResultContext.U("\ua7d6\ud208\u8a9a\u0412\u4824\u43b6\ua1e5\ucaa9\ucb4f\ucc5d\u4dbd\u7491\uf2d4\u96e0\ue3ed\u30ca\u5a7b\u43d3\u499c\ud1ba\u1c92\u52ac\u84eb\u61f8\u0df2\u2b9b\u97d3\ub860\u135c\u830b\uf516\u9a8b\ud63a\u813f\u685a\u1341\u4c54\u2abc\u9cc0\u1ea8\udf9f\ue9cd\ubecb\u1d37\uba2a\uc443\u3a7a\ub974\uc053\u5911\ub6b7\u876e\ue271")) + type;
                        throw new IllegalArgumentException(msg);
                    }
                }
                if (value == null) {
                    value = this.initializeField(structField.field, type);
                }
                try {
                    structField.size = this.getNativeSize(nativeType, value);
                    fieldAlignment = this.getNativeAlignment(nativeType, value, firstField);
                }
                catch (IllegalArgumentException e) {
                    if (!force && this.typeMapper == null) {
                        return null;
                    }
                    String msg = LastErrorException.l(Union$CallbackResultContext.U("\ua785\ud26b\u8ad7\u047f\u4862\u43d2\ua1bd\uca82\ucb30\ucc23\u4da6\u74ef\uf29b\u969c\ue3a4\u30a8\u5a25\u43ef\u4993\ud1c8\u1cd7\u52dd\u84af\u61d3\u0db7\u2bef\u97ce")) + this.getClass() + MCDAClientWindowHelper.l(Union$CallbackResultContext.U("\ua7e0\ud215\u8ac7\u0447\u486b\u43e7\ua1bd\ucab2\ucb0d\ucc06\u4db9\u74cf\uf2d8\u96ff")) + structField.name + LastErrorException.l(Union$CallbackResultContext.U("\ua7eb\ud225\u8a89")) + structField.type + MCDAClientWindowHelper.l(Union$CallbackResultContext.U("\ua7ac\ud246\u8ac8")) + e.getMessage();
                    throw new IllegalArgumentException(msg, e);
                }
                if (fieldAlignment == 0) {
                    throw new Error(LastErrorException.l(Union$CallbackResultContext.U("\ua78a\ud26c\u8ac4\u0472\u486a\u439b\ua1b8\ucace\ucb0a\ucc30\u4dba\u74f7\uf29d\u9686\ue3a5\u30fa\u5a29\u43bc\u49d5\ud1db\u1cd7\u52c3\u84a4\u61d3\u0db8\u2bee\u979c\ub850\u131c\u8375\uf55b\u9af2\ud637\u8112\u684d")) + structField.name + MCDAClientWindowHelper.l(Union$CallbackResultContext.U("\ua7a2\ud25c\u8a9f\u040e\u4833\u43aa\ua1f9\ucab5\ucb0a")) + this.getClass());
                }
                info.alignment = Math.max(info.alignment, fieldAlignment);
                if (calculatedSize % fieldAlignment != 0) {
                    calculatedSize += fieldAlignment - calculatedSize % fieldAlignment;
                }
                if (this instanceof Union) {
                    structField.offset = 0;
                    calculatedSize = Math.max(calculatedSize, structField.size);
                } else {
                    structField.offset = calculatedSize;
                    calculatedSize += structField.size;
                }
                info.fields.put(structField.name, structField);
            }
            firstField = false;
        }
        if (calculatedSize > 0) {
            int size = this.addPadding(calculatedSize, info.alignment);
            if (this instanceof ByValue && !avoidFFIType) {
                this.getTypeInfo();
            }
            info.size = size;
            return info;
        }
        throw new IllegalArgumentException(LastErrorException.l(Union$CallbackResultContext.U("\ua7e6\ud208\u8aaa\u0412\u4814\u43b6\ua1d5\ucaa9\ucb7f\ucc0e")) + this.getClass() + MCDAClientWindowHelper.l(Union$CallbackResultContext.U("\ua7ec\ud25d\u8ac0\u045d\u482e\u43fe\ua1b7\ucaf9\ucb0d\ucc08\u4da3\u74c4\uf2d8\u96b7\ue3a3\u30ca\u5a3a\u439a\u4987\ud1fe\u1c92\u52f2\u84a2\u61b9\u0dbb\u2b91\u97c6\ub825\u1314\u835f\uf54b\u9adc\ud636\u8122\u680b\u1314\u4c14\u2af5\u9c8c\u1ee7\udfdd\ue99e\ube83\u1d7f\uba30\uc402\u3a2e\ub936\uc01a\u594e\ub6e4\u8737\ue274\u2c7a\u7318\u8834")));
    }

    public void write() {
        if (this.memory == PLACEHOLDER_MEMORY) {
            return;
        }
        this.ensureAllocated();
        if (this instanceof ByValue) {
            this.getTypeInfo();
        }
        if (!Structure.busy().add(this)) {
            return;
        }
        try {
            for (StructField sf : this.fields().values()) {
                if (sf.isVolatile) continue;
                this.writeField(sf);
            }
        }
        finally {
            Structure.busy().remove(this);
        }
    }

    public boolean getAutoWrite() {
        return this.autoWrite;
    }

    public void setAutoWrite(boolean auto) {
        this.autoWrite = auto;
    }

    public String toString(boolean debug) {
        return this.toString(0, true, debug);
    }

    void useMemory(Pointer m, int offset, boolean force) {
        try {
            this.nativeStrings.clear();
            if (this instanceof ByValue && !force) {
                byte[] buf = new byte[this.size()];
                m.read(0L, buf, 0, buf.length);
                this.memory.write(0L, buf, 0, buf.length);
            } else {
                if (this.size == -1) {
                    this.size = this.calculateSize(false);
                }
                this.memory = this.size != -1 ? m.share(offset, this.size) : m.share(offset);
            }
            this.array = null;
            this.readCalled = false;
        }
        catch (IndexOutOfBoundsException e) {
            throw new IllegalArgumentException(LastErrorException.l(Klass$JNIEnv.n("\u34d8\u8869\u9ad3\u6b0e\u380e\ub10d\u6639\uc3f8\ued8e\u6c1f\uc0d2\u9427\u332c\u8958\u72a6\u9e96\u4880\u125e\u6ed9\uf1d7\ubd9d\u21b7\u2789\uf30b\ubcfb\u8350\u739a\u2bb5\uaedf\u12d0\u7160\u2a7c\ub8b4\u6e46\u5970\u8b61\ub788\uafda\u7193\u932a")), e);
        }
    }

    static int size(Class<? extends Structure> type) {
        return Structure.size(type, null);
    }

    protected List<Field> getFieldList() {
        ArrayList<Field> flist = new ArrayList<Field>();
        Class<?> cls = this.getClass();
        while (!cls.equals(Structure.class)) {
            ArrayList<Field> classFields = new ArrayList<Field>();
            Field[] fields = cls.getDeclaredFields();
            for (int i = 0; i < fields.length; ++i) {
                int modifiers = fields[i].getModifiers();
                if (Modifier.isStatic(modifiers) || !Modifier.isPublic(modifiers)) continue;
                classFields.add(fields[i]);
            }
            flist.addAll(0, classFields);
            cls = cls.getSuperclass();
        }
        return flist;
    }

    protected Structure(int alignType, TypeMapper mapper) {
        this(null, alignType, mapper);
    }

    protected Structure(TypeMapper mapper) {
        this(null, 0, mapper);
    }

    protected void cacheTypeInfo(Pointer p) {
        this.typeInfo = p.peer;
    }

    private static class AutoAllocated
    extends Memory {
        public AutoAllocated(int size) {
            super(size);
            super.clear();
        }

        @Override
        public String toString() {
            return CallbackThreadInitializer.l(Union$CallbackResultContext.U("\u04ca\u9a0b\u47b4\u699f\ud5b8")) + super.toString();
        }
    }

    @FieldOrder(value={"size", "alignment", "type", "elements"})
    static class FFIType
    extends Structure {
        private static final Map<Class, FFIType> unionHelper;
        private static final Map<Class, Map<Integer, FFIType>> typeInfoMap;
        public short type = (short)13;
        public size_t size;
        private static final int FFI_TYPE_STRUCT = 13;
        public short alignment;
        public Pointer elements;
        private static final Map<Pointer, FFIType> ffiTypeInfo;

        public FFIType(FFIType reference) {
            this.size = reference.size;
            this.alignment = reference.alignment;
            this.type = reference.type;
            this.elements = reference.elements;
        }

        private /* synthetic */ void init(Pointer[] els) {
            this.elements = new Memory(Native.POINTER_SIZE * els.length);
            this.elements.write(0L, els, 0, els.length);
            this.write();
        }

        static {
            typeInfoMap = new WeakHashMap<Class, Map<Integer, FFIType>>();
            unionHelper = new WeakHashMap<Class, FFIType>();
            ffiTypeInfo = new HashMap<Pointer, FFIType>();
            if (Native.POINTER_SIZE == 0) {
                throw new Error(WeakMemoryHolder.l(Klass$JNIEnv.n("\u505c\ue727\u41f0\ud274\u918b\ue300\u6543\ue4e6\u98ff\u27ff\u889c\u9836\u9f9e\u72a0\u0bbf\u9aac\u709e\ub0c3\ud14e\u28ca\ub306\uce11\u7d5c\u196c\u3a7f\ue6b3\u32a6\u70ee\ub786\ubc50")));
            }
            if (FFITypes.ffi_type_void == null) {
                throw new Error(LastErrorException.l(Klass$JNIEnv.n("\u503c\ue746\u41a5\ud27b\u91e1\ue35a\u657b\ue4a9\u988d\u27fb\u88e8\u987e\u9ff0\u72bf\u0b9e\u9aea\u70f0\ub085\ud16f\u2884\ub36c\uce57\u7d3a\u1926\u3a12")));
            }
            ffiTypeInfo.put(FFITypes.ffi_type_void, Structure.newInstance(FFIType.class, FFITypes.ffi_type_void));
            ffiTypeInfo.put(FFITypes.ffi_type_float, Structure.newInstance(FFIType.class, FFITypes.ffi_type_float));
            ffiTypeInfo.put(FFITypes.ffi_type_double, Structure.newInstance(FFIType.class, FFITypes.ffi_type_double));
            ffiTypeInfo.put(FFITypes.ffi_type_longdouble, Structure.newInstance(FFIType.class, FFITypes.ffi_type_longdouble));
            ffiTypeInfo.put(FFITypes.ffi_type_uint8, Structure.newInstance(FFIType.class, FFITypes.ffi_type_uint8));
            ffiTypeInfo.put(FFITypes.ffi_type_sint8, Structure.newInstance(FFIType.class, FFITypes.ffi_type_sint8));
            ffiTypeInfo.put(FFITypes.ffi_type_uint16, Structure.newInstance(FFIType.class, FFITypes.ffi_type_uint16));
            ffiTypeInfo.put(FFITypes.ffi_type_sint16, Structure.newInstance(FFIType.class, FFITypes.ffi_type_sint16));
            ffiTypeInfo.put(FFITypes.ffi_type_uint32, Structure.newInstance(FFIType.class, FFITypes.ffi_type_uint32));
            ffiTypeInfo.put(FFITypes.ffi_type_sint32, Structure.newInstance(FFIType.class, FFITypes.ffi_type_sint32));
            ffiTypeInfo.put(FFITypes.ffi_type_uint64, Structure.newInstance(FFIType.class, FFITypes.ffi_type_uint64));
            ffiTypeInfo.put(FFITypes.ffi_type_sint64, Structure.newInstance(FFIType.class, FFITypes.ffi_type_sint64));
            ffiTypeInfo.put(FFITypes.ffi_type_pointer, Structure.newInstance(FFIType.class, FFITypes.ffi_type_pointer));
            for (FFIType f : ffiTypeInfo.values()) {
                f.read();
            }
            FFIType.storeTypeInfo(Void.TYPE, 0, FFIType.ffiTypeInfo.get(FFITypes.ffi_type_void));
            FFIType.storeTypeInfo(Void.class, 0, FFIType.ffiTypeInfo.get(FFITypes.ffi_type_void));
            FFIType.storeTypeInfo(Float.TYPE, 0, FFIType.ffiTypeInfo.get(FFITypes.ffi_type_float));
            FFIType.storeTypeInfo(Float.class, 0, FFIType.ffiTypeInfo.get(FFITypes.ffi_type_float));
            FFIType.storeTypeInfo(Double.TYPE, 0, FFIType.ffiTypeInfo.get(FFITypes.ffi_type_double));
            FFIType.storeTypeInfo(Double.class, 0, FFIType.ffiTypeInfo.get(FFITypes.ffi_type_double));
            FFIType.storeTypeInfo(Long.TYPE, 0, FFIType.ffiTypeInfo.get(FFITypes.ffi_type_sint64));
            FFIType.storeTypeInfo(Long.class, 0, FFIType.ffiTypeInfo.get(FFITypes.ffi_type_sint64));
            FFIType.storeTypeInfo(Integer.TYPE, 0, FFIType.ffiTypeInfo.get(FFITypes.ffi_type_sint32));
            FFIType.storeTypeInfo(Integer.class, 0, FFIType.ffiTypeInfo.get(FFITypes.ffi_type_sint32));
            FFIType.storeTypeInfo(Short.TYPE, 0, FFIType.ffiTypeInfo.get(FFITypes.ffi_type_sint16));
            FFIType.storeTypeInfo(Short.class, 0, FFIType.ffiTypeInfo.get(FFITypes.ffi_type_sint16));
            FFIType ctype = Native.WCHAR_SIZE == 2 ? ffiTypeInfo.get(FFITypes.ffi_type_uint16) : ffiTypeInfo.get(FFITypes.ffi_type_uint32);
            FFIType.storeTypeInfo(Character.TYPE, 0, ctype);
            FFIType.storeTypeInfo(Character.class, 0, ctype);
            FFIType.storeTypeInfo(Byte.TYPE, 0, FFIType.ffiTypeInfo.get(FFITypes.ffi_type_sint8));
            FFIType.storeTypeInfo(Byte.class, 0, FFIType.ffiTypeInfo.get(FFITypes.ffi_type_sint8));
            FFIType.storeTypeInfo(Pointer.class, 0, FFIType.ffiTypeInfo.get(FFITypes.ffi_type_pointer));
            FFIType.storeTypeInfo(String.class, 0, FFIType.ffiTypeInfo.get(FFITypes.ffi_type_pointer));
            FFIType.storeTypeInfo(WString.class, 0, FFIType.ffiTypeInfo.get(FFITypes.ffi_type_pointer));
            FFIType.storeTypeInfo(Boolean.TYPE, 0, FFIType.ffiTypeInfo.get(FFITypes.ffi_type_uint32));
            FFIType.storeTypeInfo(Boolean.class, 0, FFIType.ffiTypeInfo.get(FFITypes.ffi_type_uint32));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static FFIType get(Object obj) {
            if (obj == null) {
                Map<Class, Map<Integer, FFIType>> map = typeInfoMap;
                synchronized (map) {
                    return FFIType.getTypeInfo(Pointer.class, 0);
                }
            }
            if (obj instanceof Class) {
                return FFIType.get(null, (Class)obj);
            }
            return FFIType.get(obj, obj.getClass());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static /* synthetic */ void storeTypeInfo(Class clazz, int elementCount, FFIType type) {
            Map<Class, Map<Integer, FFIType>> map = typeInfoMap;
            synchronized (map) {
                Map<Integer, FFIType> typeMap = typeInfoMap.get(clazz);
                if (typeMap == null) {
                    typeMap = new HashMap<Integer, FFIType>();
                    typeInfoMap.put(clazz, typeMap);
                }
                typeMap.put(elementCount, type);
            }
        }

        public FFIType(Structure ref) {
            Pointer[] els;
            ref.ensureAllocated(true);
            if (ref instanceof Union) {
                Structure unionType = null;
                int size = 0;
                boolean hasInteger = false;
                for (StructField sf : ref.fields().values()) {
                    FFIType type = ref.getFieldTypeInfo(sf);
                    if (FFIType.isIntegerType(type)) {
                        hasInteger = true;
                    }
                    if (unionType != null && size >= sf.size && (size != sf.size || !Structure.class.isAssignableFrom(sf.type))) continue;
                    unionType = type;
                    size = sf.size;
                }
                if ((Platform.isIntel() && Platform.is64Bit() && !Platform.isWindows() || Platform.isARM() || Platform.isLoongArch()) && hasInteger && FFIType.isFloatType(unionType)) {
                    unionType = new FFIType((FFIType)unionType);
                    if (((FFIType)unionType).size.intValue() == 4) {
                        ((FFIType)unionType).type = FFIType.ffiTypeInfo.get((Object)FFITypes.ffi_type_uint32).type;
                    } else if (((FFIType)unionType).size.intValue() == 8) {
                        ((FFIType)unionType).type = FFIType.ffiTypeInfo.get((Object)FFITypes.ffi_type_uint64).type;
                    }
                    unionType.write();
                }
                els = new Pointer[]{unionType.getPointer(), null};
                unionHelper.put(ref.getClass(), (FFIType)unionType);
            } else {
                els = new Pointer[ref.fields().size() + 1];
                int idx = 0;
                for (StructField sf : ref.fields().values()) {
                    els[idx++] = ref.getFieldTypeInfo(sf).getPointer();
                }
            }
            this.init(els);
            this.write();
        }

        public FFIType() {
        }

        private static /* synthetic */ boolean isFloatType(FFIType type) {
            Pointer typePointer = type.getPointer();
            return typePointer.equals(FFITypes.ffi_type_float) || typePointer.equals(FFITypes.ffi_type_double);
        }

        public FFIType(Object array, Class<?> type) {
            int length = Array.getLength(array);
            Pointer[] els = new Pointer[length + 1];
            Pointer p = FFIType.get(null, type.getComponentType()).getPointer();
            for (int i = 0; i < length; ++i) {
                els[i] = p;
            }
            this.init(els);
            this.write();
        }

        private static /* synthetic */ boolean isIntegerType(FFIType type) {
            Pointer typePointer = type.getPointer();
            return typePointer.equals(FFITypes.ffi_type_uint8) || typePointer.equals(FFITypes.ffi_type_sint8) || typePointer.equals(FFITypes.ffi_type_uint16) || typePointer.equals(FFITypes.ffi_type_sint16) || typePointer.equals(FFITypes.ffi_type_uint32) || typePointer.equals(FFITypes.ffi_type_sint32) || typePointer.equals(FFITypes.ffi_type_uint64) || typePointer.equals(FFITypes.ffi_type_sint64) || typePointer.equals(FFITypes.ffi_type_pointer);
        }

        private static /* synthetic */ FFIType get(Object obj, Class<?> cls) {
            ToNativeConverter nc;
            TypeMapper mapper = Native.getTypeMapper(cls);
            if (mapper != null && (nc = mapper.getToNativeConverter(cls)) != null) {
                cls = nc.nativeType();
            }
            Map<Class, Map<Integer, FFIType>> map = typeInfoMap;
            synchronized (map) {
                FFIType o = FFIType.getTypeInfo(cls, cls.isArray() ? Array.getLength(obj) : 0);
                if (o != null) {
                    return o;
                }
                if (Platform.HAS_BUFFERS && Buffer.class.isAssignableFrom(cls) || Callback.class.isAssignableFrom(cls)) {
                    typeInfoMap.put(cls, typeInfoMap.get(Pointer.class));
                    return typeInfoMap.get(Pointer.class).get(0);
                }
                if (Structure.class.isAssignableFrom(cls)) {
                    if (obj == null) {
                        obj = FFIType.newInstance(cls, PLACEHOLDER_MEMORY);
                    }
                    if (ByReference.class.isAssignableFrom(cls)) {
                        typeInfoMap.put(cls, typeInfoMap.get(Pointer.class));
                        return typeInfoMap.get(Pointer.class).get(0);
                    }
                    FFIType type = new FFIType((Structure)obj);
                    FFIType.storeTypeInfo(cls, 0, type);
                    return type;
                }
                if (NativeMapped.class.isAssignableFrom(cls)) {
                    NativeMappedConverter c = NativeMappedConverter.getInstance(cls);
                    return FFIType.get(c.toNative(obj, new ToNativeContext()), c.nativeType());
                }
                if (cls.isArray()) {
                    FFIType type = new FFIType(obj, cls);
                    FFIType.storeTypeInfo(cls, Array.getLength(obj), type);
                    return type;
                }
                throw new IllegalArgumentException(WeakMemoryHolder.l(FunctionResultContext$CallbackResultContext.p("\u161d\u9a50\u75fd\u07d3\uec70\u0b8a\u0aa5\ud025\u9e17\uf5b3\uc326\ub3e6\ud7ae\u68cb\u401b\uf951\u73eb")) + cls);
            }
        }

        private static /* synthetic */ FFIType getTypeInfo(Class clazz, int elementCount) {
            Map<Integer, FFIType> typeMap = typeInfoMap.get(clazz);
            if (typeMap != null) {
                return typeMap.get(elementCount);
            }
            return null;
        }

        private static class FFITypes {
            private static Pointer ffi_type_pointer;
            private static Pointer ffi_type_longdouble;
            private static Pointer ffi_type_sint16;
            private static Pointer ffi_type_sint32;
            private static Pointer ffi_type_uint32;
            private static Pointer ffi_type_void;
            private static Pointer ffi_type_float;
            private static Pointer ffi_type_sint8;
            private static Pointer ffi_type_double;
            private static Pointer ffi_type_uint64;
            private static Pointer ffi_type_uint8;
            private static Pointer ffi_type_uint16;
            private static Pointer ffi_type_sint64;

            private /* synthetic */ FFITypes() {
            }
        }

        public static class size_t
        extends IntegerType {
            private static final long serialVersionUID = 1L;

            public size_t(long value) {
                super(Native.SIZE_T_SIZE, value);
            }

            public size_t() {
                this(0L);
            }
        }
    }

    protected static class StructField {
        public FromNativeConverter readConverter;
        public FromNativeContext context;
        public boolean isVolatile;
        public Field field;
        public Class<?> type;
        public String name;
        public int size = -1;
        public boolean isReadOnly;
        public int offset = -1;
        public ToNativeConverter writeConverter;

        public String toString() {
            return this.name + FromNativeContext.l(Klass$JNIEnv.n("\u7051")) + this.offset + ToNativeContext.l(Klass$JNIEnv.n("\u705c")) + this.size + FromNativeContext.l(Klass$JNIEnv.n("\u704c\u0b4d\u71b3")) + this.type + ToNativeContext.l(Klass$JNIEnv.n("\u702e"));
        }

        protected StructField() {
        }
    }

    private static class LayoutInfo {
        private boolean variable;
        private final Map<String, StructField> fields = Collections.synchronizedMap(new LinkedHashMap());
        private int alignment = 1;
        private int size = -1;
        private TypeMapper typeMapper;
        private int alignType = 0;

        private /* synthetic */ LayoutInfo() {
        }
    }

    @Documented
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    public static @interface FieldOrder {
        public String[] value();
    }

    static class StructureSet
    extends AbstractCollection<Structure>
    implements Set<Structure> {
        Structure[] elements;
        private int count;

        @Override
        public boolean add(Structure o) {
            if (!this.contains(o)) {
                this.ensureCapacity(this.count + 1);
                this.elements[this.count++] = o;
                return true;
            }
            return false;
        }

        @Override
        public Iterator<Structure> iterator() {
            Structure[] e = new Structure[this.count];
            if (this.count > 0) {
                System.arraycopy(this.elements, 0, e, 0, this.count);
            }
            return Arrays.asList(e).iterator();
        }

        @Override
        public int size() {
            return this.count;
        }

        private /* synthetic */ int indexOf(Structure s1) {
            for (int i = 0; i < this.count; ++i) {
                Structure s2 = this.elements[i];
                if (s1 != s2 && (s1.getClass() != s2.getClass() || s1.size() != s2.size() || !s1.getPointer().equals(s2.getPointer()))) continue;
                return i;
            }
            return -1;
        }

        private /* synthetic */ void ensureCapacity(int size) {
            if (this.elements == null) {
                this.elements = new Structure[size * 3 / 2];
            } else if (this.elements.length < size) {
                Structure[] e = new Structure[size * 3 / 2];
                System.arraycopy(this.elements, 0, e, 0, this.elements.length);
                this.elements = e;
            }
        }

        public Structure[] getElements() {
            return this.elements;
        }

        StructureSet() {
        }

        @Override
        public boolean contains(Object o) {
            return this.indexOf((Structure)o) != -1;
        }

        @Override
        public boolean remove(Object o) {
            int idx = this.indexOf((Structure)o);
            if (idx != -1) {
                if (--this.count >= 0) {
                    this.elements[idx] = this.elements[this.count];
                    this.elements[this.count] = null;
                }
                return true;
            }
            return false;
        }
    }

    private static class NativeStringTracking {
        private NativeString peer;
        private final Object value;

        NativeStringTracking(Object lastValue) {
            this.value = lastValue;
        }
    }

    public static interface ByReference {
    }

    public static interface ByValue {
    }
}

